﻿using System;
using System.IO;
using System.IO.Pipes;
using System.Threading;

namespace dotnet_rings_rust
{
    public class PipeServer
    {
        public void Run(int instanceServersNumber)
        {
            NamedPipeServerStream pipeServer = new NamedPipeServerStream(
                "testpipe", 
                PipeDirection.InOut, 
                instanceServersNumber
                );

            int threadId = Thread.CurrentThread.ManagedThreadId;

            Console.WriteLine($"NamedPipeServerStream object created on thread[{threadId}].");

            // Wait for a client to connect
            pipeServer.WaitForConnection();

            Console.WriteLine($"Client connected on thread[{threadId}].");
            try
            {
                StreamString ss = new StreamString(pipeServer);

                // Verify our identity to the connected client using a
                // string that the client anticipates.

                ss.WriteString("I am the one true server!");
                string filename = ss.ReadString();
                Console.WriteLine("Received request for file: {0}", filename);

                // Read in the contents of the file while impersonating the client.
                ReadFileToStream fileReader = new ReadFileToStream(ss, filename);

                // Display the name of the user we are impersonating.
                Console.WriteLine("Reading file: {0} on thread[{1}] as user: {2}.",
                    filename, threadId, pipeServer.GetImpersonationUserName());

                pipeServer.RunAsClient(fileReader.Read);

                Console.WriteLine("File content sent to client");
            }
            // Catch the IOException that is raised if the pipe is broken
            // or disconnected.
            catch (IOException e)
            {
                Console.WriteLine($"ERROR: {e.Message}");
            }
            pipeServer.Close();
        }

        public void RunForUTF8(int instanceServersNumber)
        {
            NamedPipeServerStream pipeServer = new NamedPipeServerStream(
                "testpipe",
                PipeDirection.InOut,
                instanceServersNumber
                );

            int threadId = Thread.CurrentThread.ManagedThreadId;

            Console.WriteLine($"NamedPipeServerStream object created on thread[{threadId}].");

            // Wait for a client to connect
            pipeServer.WaitForConnection();

            Console.WriteLine($"Client connected on thread[{threadId}].");
            try
            {
                StreamString ss = new StreamString(pipeServer);

                // Verify our identity to the connected client using a
                // string that the client anticipates.

                ss.WriteUTF8String("I am the one true server!");
                string filename = ss.ReadUTF8String();
                Console.WriteLine("Received request for file: {0}", filename);

                // Read in the contents of the file while impersonating the client.
                ReadFileToStream fileReader = new ReadFileToStream(ss, filename);

                // Display the name of the user we are impersonating.
                Console.WriteLine("Reading file: {0} on thread[{1}] as user: {2}.",
                    filename, threadId, pipeServer.GetImpersonationUserName());

                pipeServer.RunAsClient(fileReader.ReadAsUTF8);

                Console.WriteLine("File content sent to client");
            }
            // Catch the IOException that is raised if the pipe is broken
            // or disconnected.
            catch (IOException e)
            {
                Console.WriteLine($"ERROR: {e.Message}");
            }
            pipeServer.Close();
        }
    }
}
