﻿using System.IO;

namespace dotnet_rings_rust
{
    /// <summary>
    /// Reads the contents of a file and writes it to a StreamString.
    /// </summary>
    public class ReadFileToStream
    {
        private readonly string fn;
        private readonly StreamString ss;

        public ReadFileToStream(StreamString str, string filename)
        {
            fn = filename;
            ss = str;
        }

        public void Read()
        {
            string contents = File.ReadAllText(fn);
            ss.WriteString(contents);
        }

        public void ReadAsUTF8()
        {
            string contents = File.ReadAllText(fn);
            ss.WriteUTF8String(contents);
        }
    }
}